FUNCTION_BLOCK FB_registers_display_program_sync
VAR_INPUT
PointNR							: USINT ;
New_Value						: REAL ;
END_VAR

VAR
iTemp, iURV						: INT 	;
dispTemp						: UDINT ;
regTemp							: WORD ;
register_PointValue				: REAL ;
display_Pointvalue				: REAL ;
Old_Value						: REAL ;
ModbusSilence					: UDINT := 0 ;
ModbusBreechDetected			: BOOL := FALSE ;
ModbusCommBackCounter			: INT := 0 ;
END_VAR
(* for points that can be changed from UI, remotely, AND by the internal m24 program *)
(* 1 instance for each point that can be changed from UI, remotely, AND by the internal m24 program *)

(* first we check of communication with the external Modbus master is OK. *)
ModbusSilence := GetModbusTickF (9999);																								(* get the # of msec since last received message from Modbus master *)
IF ModbusSilence>12000 THEN ModbusBreechDetected:=TRUE; END_IF ;																	(* raise a flag after 12 seconds of no communication *)
IF ModbusBreechDetected AND ModbusSilence<1500 THEN																					(* there has been a communication breech and communication started again *)
	ModbusCommBackCounter := ModbusCommBackCounter + 1 ;																			(* start counting the new communication *)
	IF ModbusCommBackCounter>20 THEN																								(* after 10 seconds of again stable communication *)
		ModbusBreechDetected := FALSE ;																								(* reset the "no comms" flag *)
		ModbusCommBackCounter := 0 ;																								(* reset the "comm error fixed" counter *)
	END_IF ;
ELSIF ModbusBreechDetected THEN																										(* comm has been down and still not stable *)
	ModbusCommBackCounter := 0 ;																									(* reset the "comm error fixed" counter *)
ELSE																																(* "no comm" flag is off *)
	ModbusCommBackCounter := 0 ;																									(* reset the "comm error fixed" counter; just to be sure; probably stricktly isn't necessary here *)
END_IF ;

IF ProgramValues[PointNR]<>New_Value THEN																							(* point value changed from program *)
	ProgramValues[PointNR] 	:= New_Value ;																							(* update the program values array *)
	iURV 					:= SetDisplayPointValueF (PointNR, DisplayAddress, REAL_TO_DINT(ProgramValues[PointNR]));				(* write display point *)
	iTemp					:= REAL_TO_INT(ProgramValues[PointNR]) ;
	iURV 					:= SetRegisterF (USINT_TO_UINT(PointNR), INT_TO_WORD(iTemp));											(* write register *)
ELSE																																(* point value was not changed from program *)
	display_Pointvalue 		:= GetDisplayPointValueF 	(PointNR, DisplayAddress, ProgramValues[PointNR]);
	iURV 					:= SetDisplayPointValueF 	(PointNR, DisplayAddress, REAL_TO_DINT(display_Pointvalue));				(* write display point back *)

	regTemp 				:= GetRegisterF(USINT_TO_UINT(PointNR)) ;																(* read register value *)
	iTemp 					:= WORD_TO_INT (regTemp) ;																				(* convert to int *)
	register_PointValue		:= INT_TO_REAL (iTemp) ;																				(* convert to real *)
	
	IF display_Pointvalue<>ProgramValues[PointNR] THEN																				(* if the display has been updated last *)
		ProgramValues[PointNR] 	:= display_Pointvalue ;																				(* save the new value from the display *)
		iTemp					:= REAL_TO_INT(display_Pointvalue) ;
		iURV 					:= SetRegisterF (USINT_TO_UINT(PointNR), INT_TO_WORD(iTemp));										(* write the new value to the register *)
	ELSIF register_PointValue<>ProgramValues[PointNR] AND ModbusBreechDetected=FALSE THEN											(* if register value was changed (remotely), and this is not just because the remote master just started communicating and had old saved values *)
		ProgramValues[PointNR] 	:= register_PointValue ;																			(* save the new value from the register *)
		iURV 					:= SetDisplayPointValueF (PointNR, DisplayAddress, REAL_TO_DINT(register_PointValue));				(* write the new value to the display *)
	END_IF ;
END_IF ;
END_FUNCTION_BLOCK